/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

//Chengarda recreates IQ's beautyPI logo (with some twists)

float hash( float n )
{
    return fract(sin(n)*43758.5453); 
    // sort of like a RNG (actually a hash), takes the fractional (errorful) part of a big number
    // main idea is that small change in input will have large unpredictable shanges in output:
    // give it a 'sensible' number, it'll return something -1 <-> 1, that looks randomish 
    //(as in doesn't appear to relate to the input)
}

float noise( in vec2 x )
{
    vec2 p = floor(x);//seperate the integer and fraction parts of x
    vec2 f = fract(x);

    f = f*f*(3.0-2.0*f); 
    //f is from -1 to +1, (-5 <-> +1)*f^2, f^2 will lift up the smllest and highest values, not 100% on the aim
    //could well have been trial and error optimised for prettiness

    float n = p.x + p.y*57.0;
    //y axis gets stretched heaps?

    float res = mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                    mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y);
    //ok so hash will always return a 'randomish' number in the same range, so n is essentially used like a  seed?
    //mix interpolates between values to smooth out the space between random samples
    
    return res;
}

float fbm (vec2 p)
{
 
    //adds together some different frequency noises, 
    
    float f = 0.0;
    f += 0.5000*noise(p); p *= 2.01;
    f += 0.2500*noise(p); p *= 1.99;
    f += 0.1250*noise(p); p *= 2.02;
    f += 0.0625*noise(p); p *= 2.01;
    f /= 0.9375;
    return f;
    
}

void main(void)
{
	vec2 p = gl_FragCoord.xy / iResolution.xy;
    vec2 q = 1.0 - 2.0*p;
    q.x *= iResolution.x/iResolution.y;
    
    vec3 col;
    
    float r = sqrt(dot(q,q));
    float a = atan(q.y, q.x);
    
    col = vec3(1.0, 1.0, 0.9);
    
    float ss = 0.5 + 0.5*sin(3.0*iGlobalTime);
    
    vec2 qe = vec2(1.7*q.x, 0.7*q.y);
    float re = sqrt(dot(qe, qe));
    re *= 1.0  - 0.02*sin(60.0*a);
    
    float anim = 1.0 + 0.1*ss*clamp(0.0, 1.0, r);
    r  *= anim;
    float anime = 1.0 + 0.5*ss*clamp(0.0, 1.0, re);
    re *= anime;
    //a += 0.6*iGlobalTime;
    
    
    if (r < 0.9)
    {
        //blueish iris
        col = vec3(0.8, 0.35, 0.4);
        
        //green iris clouds
        float f = fbm(7.0*q);
        col = mix(col, vec3(0.9, 0.2, 0.7), 1.0*f);

        //white streaks
        a += 0.15*fbm(3.0*q);
        f = smoothstep(0.05, 1.6, fbm(vec2(8.0*r, 37.0*a)));
        col = mix(col, vec3(1.0), f);
        
        //Dark Streaks
        f = smoothstep(0.3, 1.0, fbm(vec2(8.0*r, 30.0*a)));
        col = mix(col, vec3(0.2, 0.2, 0.2), f);
        
        //yellow corona
        f = 1.0 - smoothstep(0.3, 0.7, r);
        col = mix(col, vec3(0.8, 0.6, 0.1), f);
        
        //black pupil
        f = smoothstep(0.28, 0.35, re);
        col *= f;
        
        //darken outside
        f = smoothstep(0.6, 0.95, r);
        col *= 1.0 - 0.8*f;
        
        //smooth faded edge
        f = smoothstep(0.65, 0.92, r);
        col = mix(col, vec3(1.0), f);
        
        //specular highlight/reflection
        f = 1.0 - smoothstep(0.0,0.3, length(p - vec2(0.65, 0.65)));
        col += vec3(0.7, 0.6, 0.2)*0.9*f;
    }
    
    if ((q.y < 0.05)&&(q.y > -0.05))
    {
      float f = smoothstep(0.65, 0.665, p.x);
      //col = mix(col, vec3(0.0), f);   
      
      f = 1.0 - smoothstep(0.01, 0.06, p.y);
      col = mix(col, vec3(1.0), f);   
    }
    

	gl_FragColor = vec4(col, 1.0);
}